/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.utils.reflection.ReflectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public enum ModifierType {
    PUBLIC{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isPublic(modifiers);
        }
    }
    ,
    PRIVATE{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isPrivate(modifiers);
        }
    }
    ,
    PROTECTED{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isProtected(modifiers);
        }
    }
    ,
    STATIC{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isStatic(modifiers);
        }
    }
    ,
    FINAL{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isFinal(modifiers);
        }
    }
    ,
    SYNCHRONIZED{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isSynchronized(modifiers);
        }
    }
    ,
    VOLATILE{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isVolatile(modifiers);
        }
    }
    ,
    TRANSIENT{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isTransient(modifiers);
        }
    }
    ,
    NATIVE{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isNative(modifiers);
        }
    }
    ,
    INTERFACE{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isInterface(modifiers);
        }
    }
    ,
    ABSTRACT{

        @Override
        public boolean is(int modifiers) {
            return Modifier.isAbstract(modifiers);
        }
    };


    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public abstract boolean is(int var1);

    public boolean not(int modifiers) {
        return !this.is(modifiers);
    }

    public boolean is(Class clazz) {
        return this.is(clazz.getModifiers());
    }

    public boolean not(Class clazz) {
        return !this.is(clazz);
    }

    public boolean is(Field field) {
        return this.is(field.getModifiers());
    }

    public boolean not(Field field) {
        return !this.is(field);
    }

    public boolean is(Method method) {
        return this.is(method.getModifiers());
    }

    public boolean not(Method method) {
        return !this.is(method);
    }

    public void check(Class clazz) {
        if (!this.is(clazz)) {
            throw new ReflectionException("Class is not " + (Object)((Object)this) + ": " + clazz);
        }
    }

    public void check(Field field) {
        if (!this.is(field)) {
            throw new ReflectionException("Field is not " + (Object)((Object)this) + ": " + field);
        }
    }

    public void check(Method method) {
        if (!this.is(method)) {
            throw new ReflectionException("Method is not " + (Object)((Object)this) + ": " + method);
        }
    }

    public void checkNot(Class clazz) {
        if (this.is(clazz)) {
            throw new ReflectionException("Class is " + (Object)((Object)this) + ": " + clazz);
        }
    }

    public void checkNot(Field field) {
        if (this.is(field)) {
            throw new ReflectionException("Field is " + (Object)((Object)this) + ": " + field);
        }
    }

    public void checkNot(Method method) {
        if (this.is(method)) {
            throw new ReflectionException("Method is " + (Object)((Object)this) + ": " + method);
        }
    }

    public static List<ModifierType> get(int modifiers) {
        ArrayList<ModifierType> modifierTypes = new ArrayList<ModifierType>();
        for (ModifierType modifierType : ModifierType.values()) {
            if (!modifierType.is(modifiers)) continue;
            modifierTypes.add(modifierType);
        }
        return modifierTypes;
    }

    public static List<ModifierType> get(Class clazz) {
        return ModifierType.get(clazz.getModifiers());
    }

    public static List<ModifierType> get(Field field) {
        return ModifierType.get(field.getModifiers());
    }

    public static List<ModifierType> get(Method method) {
        return ModifierType.get(method.getModifiers());
    }
}

