/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiFunction;
import com.alee.api.jdk.BiPredicate;
import com.alee.api.jdk.Function;
import com.alee.utils.collection.ImmutableSet;
import com.alee.utils.collection.WeakHashSet;
import java.util.Set;
import javax.swing.JComponent;

public class WeakComponentData<C extends JComponent, D> {
    protected final String key;
    protected final Set<C> components;

    public WeakComponentData(String key, int initialCapacity) {
        this.key = key;
        this.components = new WeakHashSet<C>(initialCapacity);
    }

    public synchronized Set<C> components() {
        return new ImmutableSet<C>(this.components);
    }

    public synchronized int size() {
        return this.components.size();
    }

    public synchronized boolean contains(C component) {
        return this.components.contains(component);
    }

    public synchronized D get(C component) {
        return (D)((JComponent)component).getClientProperty(this.key);
    }

    public synchronized D get(C component, Function<C, D> defaultData) {
        D data = this.get(component);
        if (data == null) {
            data = defaultData.apply(component);
            this.set(component, data);
        }
        return data;
    }

    public synchronized D modify(C component, BiFunction<C, D, D> modifiedData, Function<C, D> defaultData) {
        D data = this.get(component);
        if (data == null) {
            data = defaultData.apply(component);
            this.set(component, data);
        } else {
            data = modifiedData.apply(component, data);
            this.set(component, data);
        }
        return data;
    }

    public synchronized D set(C component, D data) {
        D oldData = this.get(component);
        if (data != null) {
            ((JComponent)component).putClientProperty(this.key, data);
            this.components.add(component);
        } else {
            this.clear(component);
        }
        return oldData;
    }

    public synchronized D set(C component, D data, BiConsumer<C, D> oldDataConsumer) {
        D oldData;
        if (this.contains(component)) {
            oldData = this.get(component);
            oldDataConsumer.accept(component, this.get(component));
        } else {
            oldData = null;
        }
        if (data != null) {
            this.set(component, data);
        } else {
            this.clear(component, oldDataConsumer);
        }
        return oldData;
    }

    public synchronized D clear(C component) {
        D oldData = this.get(component);
        ((JComponent)component).putClientProperty(this.key, null);
        this.components.remove(component);
        return oldData;
    }

    public synchronized D clear(C component, BiConsumer<C, D> removedDataConsumer) {
        Object oldData;
        if (this.contains(component)) {
            oldData = this.get(component);
            removedDataConsumer.accept(component, oldData);
            this.clear(component);
        } else {
            oldData = null;
        }
        return (D)oldData;
    }

    public synchronized void forEach(BiConsumer<C, D> consumer) {
        for (JComponent component : this.components()) {
            D data = this.get(component);
            consumer.accept(component, data);
        }
    }

    public synchronized boolean anyMatch(BiPredicate<C, D> predicate) {
        for (JComponent component : this.components()) {
            if (!predicate.test(component, this.get(component))) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean allMatch(BiPredicate<C, D> predicate) {
        for (JComponent component : this.components()) {
            if (predicate.test(component, this.get(component))) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean noneMatch(BiPredicate<C, D> predicate) {
        for (JComponent component : this.components()) {
            if (!predicate.test(component, this.get(component))) continue;
            return false;
        }
        return true;
    }
}

