/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiPredicate;
import com.alee.utils.CollectionUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.swing.WeakComponentData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;

public class WeakComponentDataList<C extends JComponent, E>
extends WeakComponentData<C, List<E>> {
    public WeakComponentDataList(String key, int initialCapacity) {
        super(key, initialCapacity);
    }

    public synchronized int size(C component) {
        List list = (List)this.get(component);
        return list != null ? list.size() : 0;
    }

    public synchronized boolean containsData(C component) {
        return CollectionUtils.notEmpty((Collection)this.get(component));
    }

    public synchronized boolean containsData(C component, E data) {
        if (data != null) {
            List list = (List)this.get(component);
            return list != null && list.contains(data);
        }
        return false;
    }

    public synchronized void add(C component, E data) {
        ArrayList<E> list;
        if (data != null) {
            list = (ArrayList<E>)this.get(component);
            if (list == null) {
                list = new ArrayList<E>(1);
                this.set(component, list);
            }
        } else {
            throw new NullPointerException("WeakComponentDataList is not designed to store null values");
        }
        list.add(data);
    }

    public synchronized void remove(C component, E data) {
        List list;
        if (data != null && (list = (List)this.get(component)) != null) {
            list.remove(data);
            if (list.size() == 0) {
                this.clear(component);
            }
        }
    }

    public synchronized void remove(C component, E data, BiConsumer<C, E> removedDataConsumer) {
        List list;
        if (data != null && (list = (List)this.get(component)) != null && list.contains(data)) {
            removedDataConsumer.accept(component, data);
            list.remove(data);
            if (list.size() == 0) {
                this.clear(component);
            }
        }
    }

    public synchronized void forEachData(BiConsumer<C, E> consumer) {
        for (JComponent component : this.components()) {
            List mutableList = (List)this.get(component);
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                consumer.accept(component, data);
            }
        }
    }

    public synchronized void forEachData(C component, BiConsumer<C, E> consumer) {
        List mutableList = (List)this.get(component);
        if (mutableList != null) {
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                consumer.accept(component, data);
            }
        }
    }

    public synchronized boolean anyDataMatch(BiPredicate<C, E> predicate) {
        for (JComponent component : this.components()) {
            List mutableList = (List)this.get(component);
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                if (!predicate.test(component, data)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean anyDataMatch(C component, BiPredicate<C, E> predicate) {
        List mutableList = (List)this.get(component);
        if (mutableList != null) {
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                if (!predicate.test(component, data)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean allDataMatch(BiPredicate<C, E> predicate) {
        for (JComponent component : this.components()) {
            List mutableList = (List)this.get(component);
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                if (predicate.test(component, data)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean allDataMatch(C component, BiPredicate<C, E> predicate) {
        List mutableList = (List)this.get(component);
        if (mutableList != null) {
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                if (predicate.test(component, data)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean noneDataMatch(BiPredicate<C, E> predicate) {
        for (JComponent component : this.components()) {
            List mutableList = (List)this.get(component);
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                if (!predicate.test(component, data)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean noneDataMatch(C component, BiPredicate<C, E> predicate) {
        List mutableList = (List)this.get(component);
        if (mutableList != null) {
            ImmutableList dataList = new ImmutableList(mutableList);
            for (Object data : dataList) {
                if (!predicate.test(component, data)) continue;
                return false;
            }
        }
        return true;
    }
}

