/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.system;

import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaVersion {
    private static final Pattern versionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_([^-]+))?(.*)");
    private static final Pattern simpleVersionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(.*)");
    private final double major;
    private final int minor;
    private final int update;
    private final String patch;

    public JavaVersion(double major, int update) {
        this(major, 0, update);
    }

    public JavaVersion(double major, int minor, int update) {
        this(major, minor, update, null);
    }

    public JavaVersion(double major, int minor, int update, String patch) {
        this.major = major;
        this.minor = minor;
        this.update = update;
        this.patch = patch;
    }

    public JavaVersion() {
        String patch;
        int update;
        int minor;
        double major;
        block14: {
            major = 0.0;
            minor = 0;
            update = 0;
            patch = null;
            Object version = ReflectUtils.callStaticMethodSafely(Runtime.class, "version", new Object[0]);
            if (version != null) {
                major = ((Integer)ReflectUtils.callMethodSafely(version, "major", new Object[0])).intValue();
                minor = (Integer)ReflectUtils.callMethodSafely(version, "minor", new Object[0]);
                update = (Integer)ReflectUtils.callMethodSafely(version, "security", new Object[0]);
                patch = null;
            } else {
                String versionString = SystemUtils.getJavaVersionString();
                try {
                    String s;
                    Matcher matcher = versionPattern.matcher(versionString);
                    if (!matcher.matches()) break block14;
                    int groups = matcher.groupCount();
                    major = Double.parseDouble(matcher.group(1));
                    if (groups >= 3 && matcher.group(3) != null) {
                        minor = Integer.parseInt(matcher.group(3));
                    }
                    if (groups >= 5 && matcher.group(5) != null) {
                        try {
                            update = Integer.parseInt(matcher.group(5));
                        }
                        catch (NumberFormatException e) {
                            patch = matcher.group(5);
                        }
                    }
                    if (groups >= 6 && matcher.group(6) != null && (s = matcher.group(6)) != null && s.trim().length() > 0) {
                        patch = s;
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        Matcher matcher = simpleVersionPattern.matcher(versionString);
                        if (matcher.matches()) {
                            int groups = matcher.groupCount();
                            major = Double.parseDouble(matcher.group(1));
                            if (groups >= 3 && matcher.group(3) != null) {
                                minor = Integer.parseInt(matcher.group(3));
                            }
                        }
                    }
                    catch (NumberFormatException e1) {
                        major = 1.4;
                        minor = 0;
                        update = 0;
                    }
                }
            }
        }
        if (major == 0.0) {
            throw new RuntimeException("Unable to determine Java runtime version");
        }
        this.major = major;
        this.minor = minor;
        this.update = update;
        this.patch = patch;
    }

    public double major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int update() {
        return this.update;
    }

    public String patch() {
        return this.patch;
    }

    public int compareTo(JavaVersion version) {
        return this.compareTo(version.major(), version.minor(), version.update());
    }

    public int compareTo(double major, int minor, int update) {
        double majorResult = this.major - major;
        if (majorResult != 0.0) {
            return majorResult < 0.0 ? -1 : 1;
        }
        int result = this.minor - minor;
        if (result != 0) {
            return result;
        }
        return this.update - update;
    }

    public String toString() {
        return "Java " + this.major() + "." + this.minor() + " u" + this.update();
    }
}

