/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.api.jdk.Objects;
import com.alee.utils.ColorUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Color;
import java.util.Map;

public class ColorConverter
extends AbstractSingleValueConverter {
    public static final String NULL_COLOR = "null";
    public static final String NONE_COLOR = "none";
    private static final Map<String, Color> defaultColors = MapUtils.newHashMap("null", null, "none", null, "transparent", ColorUtils.transparent(), "black", Color.BLACK, "white", Color.WHITE, "red", Color.RED, "green", Color.GREEN, "blue", Color.BLUE, "lightGray", Color.LIGHT_GRAY, "gray", Color.GRAY, "darkGray", Color.DARK_GRAY, "pink", Color.PINK, "orange", Color.ORANGE, "yellow", Color.YELLOW, "magenta", Color.MAGENTA, "cyan", Color.CYAN);

    public boolean canConvert(Class type) {
        return Color.class.isAssignableFrom(type);
    }

    public String toString(Object object) {
        Color color = (Color)object;
        return ColorConverter.colorToString(color);
    }

    public Object fromString(String color) {
        return ColorConverter.colorFromString(color);
    }

    public static String colorToString(Color color) {
        if (defaultColors.containsValue(color)) {
            for (Map.Entry<String, Color> entry : defaultColors.entrySet()) {
                if (!Objects.equals((Object)color, (Object)entry.getValue())) continue;
                return entry.getKey();
            }
            throw new RuntimeException("Unable to find mapping for Color: " + color);
        }
        StringBuilder string = new StringBuilder(15);
        string.append(color.getRed()).append(",");
        string.append(color.getGreen()).append(",");
        string.append(color.getBlue());
        if (color.getAlpha() < 255) {
            string.append(",").append(color.getAlpha());
        }
        return string.toString();
    }

    public static Color colorFromString(String color) {
        try {
            if (defaultColors.containsKey(color)) {
                return defaultColors.get(color);
            }
            if (color.contains("#")) {
                return ColorUtils.fromHex(color);
            }
            return ColorUtils.fromRGB(color);
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Color: " + color, e);
        }
    }
}

