/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Dimension;
import java.util.StringTokenizer;

public class DimensionConverter
extends AbstractSingleValueConverter {
    public static final String SEPARATOR = ",";

    public boolean canConvert(Class type) {
        return Dimension.class.isAssignableFrom(type);
    }

    public String toString(Object object) {
        return DimensionConverter.dimensionToString((Dimension)object);
    }

    public Object fromString(String dimension) {
        return DimensionConverter.dimensionFromString(dimension);
    }

    public static String dimensionToString(Dimension dimension) {
        return dimension.width + SEPARATOR + dimension.height;
    }

    public static Dimension dimensionFromString(String dimension) {
        try {
            if (dimension.contains(SEPARATOR)) {
                StringTokenizer tokenizer = new StringTokenizer(dimension, SEPARATOR, false);
                int width = Integer.parseInt(tokenizer.nextToken().trim());
                int height = Integer.parseInt(tokenizer.nextToken().trim());
                return new Dimension(width, height);
            }
            int width = Integer.parseInt(dimension);
            return new Dimension(width, width);
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Dimension: " + dimension, e);
        }
    }
}

