/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class RectangleConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    public boolean canConvert(Class type) {
        return Rectangle.class.isAssignableFrom(type);
    }

    public String toString(Object object) {
        return RectangleConverter.rectangleToString((Rectangle)object);
    }

    public Object fromString(String insets) {
        return RectangleConverter.rectangleFromString(insets);
    }

    public static String rectangleToString(Rectangle rectangle) {
        return rectangle.x + separator + rectangle.y + separator + rectangle.width + separator + rectangle.height;
    }

    public static Rectangle rectangleFromString(String rectangle) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(rectangle, separator, false);
            int x = Integer.parseInt(tokenizer.nextToken().trim());
            int y = Integer.parseInt(tokenizer.nextToken().trim());
            int width = Integer.parseInt(tokenizer.nextToken().trim());
            int height = Integer.parseInt(tokenizer.nextToken().trim());
            return new Rectangle(x, y, width, height);
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Rectangle: " + rectangle, e);
        }
    }
}

