/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.api.jdk.Objects;
import com.alee.utils.xml.ResourceLocation;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.File;
import java.io.Serializable;

@XStreamAlias(value="Resource")
public class Resource
implements Serializable {
    @XStreamAsAttribute
    private ResourceLocation location;
    @XStreamAsAttribute
    private String className;
    @XStreamAsAttribute
    private String path;

    public Resource(String path) {
        this(ResourceLocation.filePath, null, path);
    }

    public Resource(File file) {
        this(ResourceLocation.filePath, null, file.getAbsolutePath());
    }

    public Resource(String className, String path) {
        this(ResourceLocation.nearClass, className, path);
    }

    public Resource(Class clazz, String path) {
        this(ResourceLocation.nearClass, clazz.getCanonicalName(), path);
    }

    public Resource(ResourceLocation location, String className, String path) {
        this.setLocation(location);
        this.setPath(path);
        this.setClassName(className);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Resource) {
            Resource other = (Resource)object;
            return other.location == this.location && Objects.equals((Object)other.className, (Object)this.className) && Objects.equals((Object)other.path, (Object)this.path);
        }
        return false;
    }
}

