/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.docconverter.html2pdf;

import com.lowagie.text.DocumentException;
import de.elnarion.util.docconverter.api.exception.ConversionException;
import de.elnarion.util.docconverter.common.AbstractBaseConverter;
import de.elnarion.util.docconverter.spi.InputType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class HTML2PDFConverter
extends AbstractBaseConverter {
    private static Map<String, Set<String>> supportedMimetypes = null;

    public HTML2PDFConverter(Map<String, Object> paramConfigurationParameters) {
        super(paramConfigurationParameters);
    }

    public static synchronized Map<String, Set<String>> getSupportedConversion() {
        if (supportedMimetypes == null) {
            supportedMimetypes = new HashMap<String, Set<String>>();
            HashSet<String> targetMimetypes = new HashSet<String>();
            targetMimetypes.add("application/pdf");
            supportedMimetypes.put("text/html", targetMimetypes);
            supportedMimetypes.put("application/xhtml+xml", targetMimetypes);
        }
        return supportedMimetypes;
    }

    protected List<InputStream> convertToInputStream(InputStream source, String paramSourceMimeType) throws ConversionException {
        ArrayList<InputStream> resultStreams = new ArrayList<InputStream>();
        if ("application/xhtml+xml".equals(paramSourceMimeType)) {
            resultStreams.add(this.convertXHTMLToPDFInputStream(source));
        } else if ("text/html".equals(paramSourceMimeType)) {
            resultStreams.add(this.convertHTMLToPDFInputStream(source));
        }
        return resultStreams;
    }

    private InputStream convertHTMLToPDFInputStream(InputStream paramSource) throws ConversionException {
        Document document;
        try {
            document = Jsoup.parse((InputStream)paramSource, (String)this.getConfiguredCharset(), (String)"");
        }
        catch (IOException e) {
            throw new ConversionException("Conversion is not possible due to an IOException. Error message is " + e.getMessage(), (Throwable)e);
        }
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        String xhtmlString = document.html();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xhtmlString.getBytes());
        return this.convertXHTMLToPDFInputStream(byteArrayInputStream);
    }

    private InputStream convertXHTMLToPDFInputStream(InputStream paramSource) throws ConversionException {
        String xhtmlString;
        try {
            xhtmlString = IOUtils.toString((InputStream)paramSource, (String)this.getConfiguredCharset());
        }
        catch (IOException e) {
            throw new ConversionException("Conversion is not possible due to an IOException. Error message is " + e.getMessage(), (Throwable)e);
        }
        ITextRenderer renderer = new ITextRenderer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.getConfigurationParameters() != null && this.getConfigurationParameters().containsKey("input.basedirectory.url")) {
            renderer.setDocumentFromString(xhtmlString, (String)this.getConfigurationParameters().get("input.basedirectory.url"));
        } else {
            renderer.setDocumentFromString(xhtmlString);
        }
        renderer.layout();
        try {
            renderer.createPDF((OutputStream)byteArrayOutputStream, false);
            renderer.finishPDF();
        }
        catch (DocumentException e) {
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static boolean isInputTypeSupported(InputType paramInputType) {
        switch (paramInputType) {
            case FILE: 
            case INPUTSTREAM: {
                return true;
            }
        }
        return false;
    }
}

