/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.immutable.factory;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.immutable.api.ImmutableMessageParser;
import io.floodplain.immutable.api.customtypes.CoordinateType;
import io.floodplain.immutable.impl.ImmutableMessageImpl;
import io.floodplain.immutable.impl.JSONImmutableMessageParserImpl;
import io.floodplain.immutable.json.ImmutableJSON;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ImmutableFactory {
    private static ImmutableMessageParser instance;
    private static final ImmutableMessage empty;
    private static final Logger logger;

    public static ImmutableMessage empty() {
        return empty;
    }

    public static ImmutableMessage create(Map<String, ?> values, Map<String, ImmutableMessage.ValueType> types) {
        return ImmutableFactory.create(values, types, Collections.emptyMap(), Collections.emptyMap());
    }

    public static ImmutableMessage create(Map<String, ?> values, Map<String, ImmutableMessage.ValueType> types, Map<String, ImmutableMessage> submessage, Map<String, List<ImmutableMessage>> submessages) {
        return new ImmutableMessageImpl(values, types, submessage, submessages);
    }

    public static ImmutableMessage create(ImmutableMessage message1, ImmutableMessage message2, String key) {
        return new ImmutableMessageImpl(message1, message2, key);
    }

    public static ImmutableMessageParser createParser() {
        return new JSONImmutableMessageParserImpl();
    }

    public static String ndJson(ImmutableMessage msg) throws IOException {
        return ImmutableJSON.ndJson(msg);
    }

    public static void setInstance(ImmutableMessageParser parser) {
        instance = parser;
    }

    public static ImmutableMessageParser getInstance() {
        return instance;
    }

    public static ImmutableMessage.ValueType resolveTypeFromValue(Object val) {
        if (val == null) {
            throw new NullPointerException("Can't resolve type from null value");
        }
        if (val instanceof Long) {
            return ImmutableMessage.ValueType.LONG;
        }
        if (val instanceof Double) {
            return ImmutableMessage.ValueType.DOUBLE;
        }
        if (val instanceof Integer) {
            return ImmutableMessage.ValueType.INTEGER;
        }
        if (val instanceof Float) {
            return ImmutableMessage.ValueType.FLOAT;
        }
        if (val instanceof Date) {
            return ImmutableMessage.ValueType.DATE;
        }
        if (val instanceof Boolean) {
            return ImmutableMessage.ValueType.BOOLEAN;
        }
        if (val instanceof String) {
            return ImmutableMessage.ValueType.STRING;
        }
        if (val instanceof CoordinateType) {
            return ImmutableMessage.ValueType.COORDINATE;
        }
        if (val instanceof byte[]) {
            return ImmutableMessage.ValueType.BINARY;
        }
        if (val instanceof String[]) {
            return ImmutableMessage.ValueType.STRINGLIST;
        }
        logger.warn("Unknown type::: {}", val.getClass());
        throw new IllegalArgumentException("Unknown type: " + val.getClass());
    }

    static {
        empty = ImmutableFactory.create(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        logger = LoggerFactory.getLogger(ImmutableFactory.class);
    }
}

