/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.immutable.impl;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.immutable.api.ImmutableMessageParser;
import io.floodplain.immutable.factory.ImmutableFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableMessageImpl
implements ImmutableMessage {
    private static final Logger logger = LoggerFactory.getLogger(ImmutableMessageImpl.class);
    private final Map<String, Object> values;
    private final Map<String, ImmutableMessage.ValueType> types;
    private final Map<String, ImmutableMessage> subMessageMap;
    private final Map<String, List<ImmutableMessage>> subMessagesMap;

    public ImmutableMessageImpl(Map<String, ? extends Object> values, Map<String, ImmutableMessage.ValueType> types, Map<String, ImmutableMessage> submessage, Map<String, List<ImmutableMessage>> submessages) {
        this.values = Collections.unmodifiableMap(values);
        this.types = Collections.unmodifiableMap(types);
        this.subMessageMap = Collections.unmodifiableMap(submessage);
        this.subMessagesMap = Collections.unmodifiableMap(submessages);
    }

    public ImmutableMessageImpl(ImmutableMessage message1, ImmutableMessage message2, String key) {
        HashMap m;
        HashMap<String, Optional> values = new HashMap<String, Optional>();
        for (String c : message1.columnNames()) {
            Optional value = message1.value(c);
            if (!value.isPresent()) continue;
            values.put(c, value);
        }
        for (String c : message2.columnNames()) {
            Optional newValue = message2.value(c);
            if (values.containsKey(c)) {
                Object original = values.get(c);
                if (!newValue.isPresent()) continue;
                if (!original.equals(newValue.get())) {
                    logger.debug("Conflict in values. Value {} is present in both messages, but different: {} vs {}", new Object[]{c, original, newValue});
                }
            }
            values.put(c, newValue);
        }
        this.values = Collections.unmodifiableMap(values);
        Map types1 = message1.types();
        Map types2 = message2.types();
        this.types = this.combineTypes(types1, types2);
        if (message1.subMessageNames().isEmpty()) {
            this.subMessageMap = message2.subMessageMap().isEmpty() ? Collections.emptyMap() : message2.subMessageMap();
        } else if (message2.subMessageMap().isEmpty()) {
            this.subMessageMap = message1.subMessageMap();
        } else {
            m = new HashMap(message1.subMessageMap());
            m.putAll(message2.subMessageMap());
            this.subMessageMap = Collections.unmodifiableMap(m);
        }
        if (message1.subMessageListMap().isEmpty()) {
            this.subMessagesMap = message2.subMessageListMap().isEmpty() ? Collections.emptyMap() : message2.subMessageListMap();
        } else if (message2.subMessageListMap().isEmpty()) {
            this.subMessagesMap = message1.subMessageListMap();
        } else {
            m = new HashMap(message1.subMessageListMap());
            m.putAll(message2.subMessageListMap());
            this.subMessagesMap = Collections.unmodifiableMap(m);
        }
    }

    public Set<String> subMessageNames() {
        if (this.subMessageMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.subMessageMap.keySet());
    }

    public Set<String> subMessageListNames() {
        if (this.subMessagesMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.subMessagesMap.keySet());
    }

    public byte[] toBytes(ImmutableMessageParser c) {
        return c.serialize((ImmutableMessage)this);
    }

    private Map<String, ImmutableMessage.ValueType> resolveTypesFromValues(Map<String, ? extends Object> values) {
        HashMap<String, ImmutableMessage.ValueType> t = new HashMap<String, ImmutableMessage.ValueType>();
        for (Map.Entry<String, ? extends Object> e : values.entrySet()) {
            t.put(e.getKey(), ImmutableFactory.resolveTypeFromValue(e.getValue()));
        }
        return t;
    }

    private Map<String, ImmutableMessage.ValueType> combineTypes(Map<String, ImmutableMessage.ValueType> typesa, Map<String, ImmutableMessage.ValueType> typesb) {
        HashMap<String, ImmutableMessage.ValueType> combine = new HashMap<String, ImmutableMessage.ValueType>(typesa);
        for (Map.Entry<String, ImmutableMessage.ValueType> e : typesb.entrySet()) {
            combine.put(e.getKey(), e.getValue());
        }
        return Collections.unmodifiableMap(combine);
    }

    public Map<String, ImmutableMessage.ValueType> types() {
        return this.types;
    }

    public Map<String, Map<String, Object>> toDataMap() {
        HashMap<String, Map<String, Object>> columns = new HashMap<String, Map<String, Object>>();
        this.values.entrySet().stream().forEach(element -> {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("Type", this.types.get(element.getKey()));
            m.put("Value", this.values.get(element.getKey()));
            columns.put((String)element.getKey(), m);
        });
        return columns;
    }

    public Map<String, Object> valueMap(boolean ignoreNull, Set<String> ignore) {
        return this.valueMap(ignoreNull, ignore, Collections.emptyList());
    }

    private static Function<String, Boolean> checkIgnoreList(Set<String> ignoreList) {
        return item -> !ignoreList.contains(item);
    }

    public Map<String, Object> valueMap(boolean ignoreNull, Set<String> ignore, List<String> currentPath) {
        LinkedList<String> withPath;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            if (ignore.contains(entry.getKey()) || entry.getValue() == null && ignoreNull || !ImmutableMessageImpl.checkIgnoreList(ignore).apply(entry.getKey()).booleanValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        if (this.subMessageMap != null) {
            for (Map.Entry<String, Object> entry : this.subMessageMap.entrySet()) {
                withPath = new LinkedList<String>(currentPath);
                withPath.add(entry.getKey());
                result.put(entry.getKey(), ((ImmutableMessage)entry.getValue()).valueMap(ignoreNull, ignore, withPath));
            }
        }
        if (this.subMessagesMap != null) {
            for (Map.Entry<String, Object> entry : this.subMessagesMap.entrySet()) {
                withPath = new LinkedList<String>(currentPath);
                withPath.add(entry.getKey());
                List elts = ((List)entry.getValue()).stream().map(msg -> msg.valueMap(ignoreNull, ignore, withPath)).collect(Collectors.toList());
                result.put(entry.getKey(), elts);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public Set<String> columnNames() {
        return this.values.keySet();
    }

    public Object columnValue(String name) {
        int path = name.indexOf(47);
        if (path == -1) {
            return this.values.get(name);
        }
        String submp = name.substring(0, path);
        Optional value = this.subMessage(submp).orElse(ImmutableFactory.empty()).value(name.substring(path + 1));
        return value.orElse(null);
    }

    public ImmutableMessage.ValueType columnType(String name) {
        return this.types.get(name);
    }

    public String toString() {
        return "Values: " + this.values + " types: " + this.types;
    }

    public Optional<List<ImmutableMessage>> subMessages(String field) {
        if (this.subMessagesMap == null) {
            return Optional.empty();
        }
        List<ImmutableMessage> messageList = this.subMessagesMap.get(field);
        if (messageList == null || messageList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(messageList);
    }

    public Optional<ImmutableMessage> subMessage(String field) {
        if (this.subMessageMap == null) {
            return Optional.empty();
        }
        ImmutableMessage message = this.subMessageMap.get(field);
        return Optional.ofNullable(message);
    }

    public ImmutableMessage withSubMessages(String field, List<ImmutableMessage> message) {
        HashMap<String, List<ImmutableMessage>> res = new HashMap<String, List<ImmutableMessage>>(this.subMessagesMap);
        res.put(field, message);
        return new ImmutableMessageImpl(this.values, this.types, this.subMessageMap, Collections.unmodifiableMap(res));
    }

    public ImmutableMessage withSubMessage(String field, ImmutableMessage message) {
        HashMap<String, ImmutableMessage> res = new HashMap<String, ImmutableMessage>(this.subMessageMap);
        res.put(field, message);
        return new ImmutableMessageImpl(this.values, this.types, Collections.unmodifiableMap(res), this.subMessagesMap);
    }

    public ImmutableMessage without(String columnName) {
        HashMap<String, Object> localValues = new HashMap<String, Object>(this.values);
        HashMap<String, ImmutableMessage.ValueType> localTypes = new HashMap<String, ImmutableMessage.ValueType>(this.types);
        localValues.remove(columnName);
        localTypes.remove(columnName);
        return new ImmutableMessageImpl(localValues, localTypes, this.subMessageMap, this.subMessagesMap);
    }

    public ImmutableMessage without(List<String> columns) {
        HashMap<String, Object> localValues = new HashMap<String, Object>(this.values);
        HashMap<String, ImmutableMessage.ValueType> localTypes = new HashMap<String, ImmutableMessage.ValueType>(this.types);
        for (String columnName : columns) {
            localValues.remove(columnName);
            localTypes.remove(columnName);
        }
        return new ImmutableMessageImpl(localValues, localTypes, this.subMessageMap, this.subMessagesMap);
    }

    public ImmutableMessage rename(String columnName, String newName) {
        if (this.columnNames().contains(columnName)) {
            return this.without(columnName).with(newName, this.columnValue(columnName), this.types.get(columnName));
        }
        return this;
    }

    public ImmutableMessage with(String key, Object value, ImmutableMessage.ValueType type) {
        int firstSlash = key.indexOf(47);
        if (firstSlash != -1) {
            String[] parts = key.split("/");
            Optional<ImmutableMessage> subm = this.subMessage(parts[0]);
            if (!subm.isPresent()) {
                logger.warn("Path: {} not found", (Object)key);
                ImmutableMessage newSub = ImmutableFactory.empty().with(key.substring(firstSlash + 1), value, type);
                return this.withSubMessage(parts[0], newSub);
            }
            return this.withSubMessage(parts[0], subm.get()).with(key.substring(firstSlash + 1), value, type);
        }
        HashMap<String, Object> localValues = new HashMap<String, Object>(this.values);
        HashMap<String, ImmutableMessage.ValueType> localTypes = new HashMap<String, ImmutableMessage.ValueType>(this.types);
        switch (type) {
            case IMMUTABLE: {
                ImmutableMessage im = (ImmutableMessage)value;
                return this.withSubMessage(key, im);
            }
            case IMMUTABLELIST: {
                List iml = (List)value;
                return this.withSubMessages(key, iml);
            }
        }
        localValues.put(key, value);
        localTypes.put(key, type);
        return new ImmutableMessageImpl(localValues, localTypes, this.subMessageMap, this.subMessagesMap);
    }

    public String toFlatString(ImmutableMessageParser parser) {
        if (parser == null) {
            logger.info("Can not flatten parser, no parser present");
            return "";
        }
        return parser.describe((ImmutableMessage)this);
    }

    public ImmutableMessage withoutSubMessages(String field) {
        HashMap<String, List<ImmutableMessage>> res = new HashMap<String, List<ImmutableMessage>>(this.subMessagesMap);
        res.remove(field);
        return new ImmutableMessageImpl(this.values, this.types, this.subMessageMap, Collections.unmodifiableMap(res));
    }

    public ImmutableMessage withoutSubMessage(String field) {
        HashMap<String, ImmutableMessage> res = new HashMap<String, ImmutableMessage>(this.subMessageMap);
        res.remove(field);
        return new ImmutableMessageImpl(this.values, this.types, Collections.unmodifiableMap(res), this.subMessagesMap);
    }

    public Map<String, ImmutableMessage> subMessageMap() {
        return this.subMessageMap;
    }

    public Map<String, List<ImmutableMessage>> subMessageListMap() {
        return this.subMessagesMap;
    }

    public ImmutableMessage merge(ImmutableMessage other, Optional<List<String>> only) {
        ImmutableMessageImpl msg = this;
        HashMap<String, ImmutableMessage> mergedSubMessageMap = new HashMap<String, ImmutableMessage>(this.subMessageMap);
        mergedSubMessageMap.putAll(other.subMessageMap());
        HashMap<String, List<ImmutableMessage>> mergedSubMessagesMap = new HashMap<String, List<ImmutableMessage>>(this.subMessagesMap);
        mergedSubMessagesMap.putAll(other.subMessageListMap());
        try {
            if (only.isPresent()) {
                for (String key : only.get()) {
                    Optional subMessages;
                    Optional subMessage;
                    ImmutableMessage lookupMsg = other;
                    while (key.contains(".") && lookupMsg != null) {
                        String submsgName = key.substring(0, key.indexOf(46));
                        key = key.substring(submsgName.length() + 1);
                        subMessage = lookupMsg.subMessage(submsgName);
                        if (subMessage.isPresent()) {
                            if (lookupMsg == other) {
                                mergedSubMessageMap.remove(submsgName);
                            }
                            lookupMsg = (ImmutableMessage)subMessage.get();
                            continue;
                        }
                        lookupMsg = null;
                    }
                    Object found = null;
                    if (lookupMsg == null) continue;
                    found = lookupMsg.columnValue(key);
                    if (found != null) {
                        msg = msg.with(key, found, lookupMsg.columnType(key));
                        continue;
                    }
                    subMessage = lookupMsg.subMessage(key);
                    if (subMessage.isPresent()) {
                        mergedSubMessageMap.put(key, (ImmutableMessage)subMessage.get());
                    }
                    if (!(subMessages = lookupMsg.subMessages(key)).isPresent()) continue;
                    mergedSubMessagesMap.put(key, (List)subMessages.get());
                }
            } else {
                for (String key : other.columnNames()) {
                    Object found = other.columnValue(key);
                    if (found == null) continue;
                    msg = msg.with(key, found, other.columnType(key));
                }
            }
        }
        catch (Throwable t) {
            logger.error("Err", t);
        }
        return msg.withAllSubMessageLists(mergedSubMessagesMap).withAllSubMessage(mergedSubMessageMap);
    }

    public ImmutableMessage withOnlySubMessages(List<String> subMessages) {
        HashMap<String, ImmutableMessage> newSubMessages = new HashMap<String, ImmutableMessage>(this.subMessageMap);
        HashMap<String, List<ImmutableMessage>> newSubMessageList = new HashMap<String, List<ImmutableMessage>>(this.subMessagesMap);
        for (String elt : this.subMessageMap.keySet()) {
            if (subMessages.contains(elt)) continue;
            newSubMessages.remove(elt);
        }
        for (String elt : this.subMessagesMap.keySet()) {
            if (subMessages.contains(elt)) continue;
            newSubMessageList.remove(elt);
        }
        return new ImmutableMessageImpl(this.values, this.types, Collections.unmodifiableMap(newSubMessages), Collections.unmodifiableMap(newSubMessageList));
    }

    public ImmutableMessage withOnlyColumns(List<String> columns) {
        HashMap<String, Object> newValues = new HashMap<String, Object>(this.values);
        HashMap<String, ImmutableMessage.ValueType> newTypes = new HashMap<String, ImmutableMessage.ValueType>(this.types);
        for (String elt : this.values.keySet()) {
            if (columns.contains(elt)) continue;
            newValues.remove(elt);
            newTypes.remove(elt);
        }
        HashMap<String, ImmutableMessage> newsubmessage = new HashMap<String, ImmutableMessage>(Collections.emptyMap());
        HashMap<String, List<ImmutableMessage>> newSubmessages = new HashMap<String, List<ImmutableMessage>>(Collections.emptyMap());
        for (String key : columns) {
            Optional subMessages;
            Optional subMessage;
            if (!key.contains(".")) continue;
            ImmutableMessageImpl lookupMsg = this;
            while (key.contains(".") && lookupMsg != null) {
                String submsgName = key.substring(0, key.indexOf("."));
                key = key.substring(submsgName.length() + 1);
                subMessage = lookupMsg.subMessage(submsgName);
                if (subMessage.isPresent()) {
                    lookupMsg = (ImmutableMessage)subMessage.get();
                    continue;
                }
                lookupMsg = null;
            }
            Object found = null;
            if (lookupMsg == null) continue;
            found = lookupMsg.columnValue(key);
            if (found != null) {
                newValues.put(key, found);
                newTypes.put(key, lookupMsg.columnType(key));
                continue;
            }
            subMessage = lookupMsg.subMessage(key);
            if (subMessage.isPresent()) {
                newsubmessage.put(key, (ImmutableMessage)subMessage.get());
            }
            if (!(subMessages = lookupMsg.subMessages(key)).isPresent()) continue;
            newSubmessages.put(key, (List)subMessages.get());
        }
        return new ImmutableMessageImpl(newValues, newTypes, newsubmessage, newSubmessages);
    }

    public ImmutableMessage withAllSubMessageLists(Map<String, List<ImmutableMessage>> subMessageListMap) {
        return new ImmutableMessageImpl(this.values, this.types, this.subMessageMap, subMessageListMap);
    }

    public ImmutableMessage withAllSubMessage(Map<String, ImmutableMessage> subMessageMap) {
        return new ImmutableMessageImpl(this.values, this.types, subMessageMap, this.subMessagesMap);
    }

    public ImmutableMessage withAddedSubMessage(String field, ImmutableMessage message) {
        ArrayList<ImmutableMessage> subMessageList = new ArrayList<ImmutableMessage>(this.subMessages(field).orElse(new ArrayList()));
        subMessageList.add(message);
        return this.withSubMessages(field, subMessageList);
    }

    public ImmutableMessage withoutSubMessageInList(String field, Predicate<ImmutableMessage> selector) {
        List<ImmutableMessage> subMessageList = this.subMessages(field).orElse(Collections.emptyList()).stream().filter(m -> !selector.test((ImmutableMessage)m)).collect(Collectors.toList());
        return this.withSubMessages(field, subMessageList);
    }

    public Map<String, Object> flatValueMap(boolean ignoreNull, Set<String> ignore, String prefix) {
        HashMap<Object, Object> localValues;
        if ("".equals(prefix)) {
            localValues = new HashMap<String, Object>(this.values);
        } else {
            localValues = new HashMap();
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                localValues.put(prefix + "/" + entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.subMessageMap.entrySet()) {
            String newPrefix = !"".equals(prefix) ? prefix + "_" + entry.getKey() : entry.getKey();
            localValues.putAll(((ImmutableMessage)entry.getValue()).flatValueMap(ignoreNull, ignore, newPrefix));
        }
        if (!this.subMessagesMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.subMessagesMap.entrySet()) {
                int i = 0;
                for (ImmutableMessage msg : (List)entry.getValue()) {
                    String pr = entry.getKey() + "@" + i;
                    String newPrefix = !"".equals(prefix) ? prefix + "/" + pr : pr;
                    msg.flatValueMap(ignoreNull, ignore, newPrefix).entrySet().forEach(ee -> localValues.put((String)ee.getKey(), ee.getValue()));
                    ++i;
                }
            }
        }
        return Collections.unmodifiableMap(localValues);
    }

    public Map<String, Object> flatValueMap(String prefix, ImmutableMessage.Trifunction processType) {
        Map<String, Object> localValues = this.getFlatValueMap(prefix, processType);
        for (Map.Entry<String, ImmutableMessage> e : this.subMessageMap.entrySet()) {
            String newPrefix = !"".equals(prefix) ? prefix + "_" + e.getKey() : e.getKey();
            localValues.putAll(e.getValue().flatValueMap(newPrefix, processType));
        }
        return Collections.unmodifiableMap(localValues);
    }

    private Map<String, Object> getFlatValueMap(String prefix, ImmutableMessage.Trifunction processType) {
        HashMap<String, Object> localValues;
        if ("".equals(prefix)) {
            localValues = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e : this.values.entrySet()) {
                ImmutableMessage.ValueType type = this.types.get(e.getKey());
                Object processed = processType.apply(e.getKey(), type, e.getValue());
                if (processed == null) continue;
                localValues.put(e.getKey(), processed);
            }
        } else {
            localValues = new HashMap();
            for (Map.Entry<String, Object> e : this.values.entrySet()) {
                ImmutableMessage.ValueType type = this.types.get(e.getKey());
                Object processed = processType.apply(e.getKey(), type, e.getValue());
                if (processed == null) continue;
                localValues.put(prefix + "_" + e.getKey(), processed);
            }
        }
        return localValues;
    }

    public boolean equalsToMessage(ImmutableMessage c) {
        Map other = c.flatValueMap(false, Collections.emptySet(), "");
        Map<String, Object> myMap = this.flatValueMap(false, Collections.emptySet(), "");
        return myMap.equals(other);
    }

    public Map<String, Object> values() {
        return this.values;
    }

    public Map<String, ImmutableMessage.TypedData> toTypedDataMap() {
        HashMap<String, ImmutableMessage.TypedData> columns = new HashMap<String, ImmutableMessage.TypedData>();
        this.values.entrySet().stream().forEach(element -> {
            ImmutableMessage.ValueType t = this.columnType((String)element.getKey());
            columns.put((String)element.getKey(), new ImmutableMessage.TypedData(t, element.getValue()));
        });
        return columns;
    }
}

