/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.immutable.impl;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.immutable.api.ImmutableMessageParser;
import io.floodplain.immutable.factory.ImmutableFactory;
import io.floodplain.immutable.json.ImmutableJSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONImmutableMessageParserImpl
implements ImmutableMessageParser {
    private static final boolean INCLUDENULLVALUES = true;
    private static final Logger logger = LoggerFactory.getLogger(JSONImmutableMessageParserImpl.class);

    public byte[] serialize(ImmutableMessage msg) {
        return ImmutableJSON.jsonSerializer(msg, true, true);
    }

    public String describe(ImmutableMessage msg) {
        return new String(ImmutableJSON.jsonSerializer(msg, true, false));
    }

    public void activate() {
        logger.info("Immutable parser constructed");
        ImmutableFactory.setInstance(this);
    }

    public void deactivate() {
        ImmutableFactory.setInstance(null);
    }
}

