/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.immutable.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.immutable.api.ImmutableTypeParser;
import io.floodplain.immutable.factory.ImmutableFactory;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableJSON {
    private static final Logger logger = LoggerFactory.getLogger(ImmutableJSON.class);
    public static final ObjectMapper objectMapper = new ObjectMapper();

    private ImmutableJSON() {
    }

    public static ObjectNode flatJson(ImmutableMessage msg) throws IOException {
        ObjectNode node = objectMapper.createObjectNode();
        msg.toTypedDataMap().entrySet().forEach(e -> ImmutableJSON.resolveValue(objectMapper, node, (String)e.getKey(), ((ImmutableMessage.TypedData)e.getValue()).type, Optional.ofNullable(((ImmutableMessage.TypedData)e.getValue()).value), false));
        for (Map.Entry e2 : msg.subMessageMap().entrySet()) {
            ImmutableJSON.flatJson((ImmutableMessage)e2.getValue(), node, (String)e2.getKey());
        }
        return node;
    }

    public static ObjectNode flatJson(ImmutableMessage msg, ObjectNode node, String prefix) throws IOException {
        msg.toTypedDataMap().entrySet().forEach(e -> ImmutableJSON.resolveValue(objectMapper, node, prefix + "_" + (String)e.getKey(), ((ImmutableMessage.TypedData)e.getValue()).type, Optional.ofNullable(((ImmutableMessage.TypedData)e.getValue()).value), false));
        for (Map.Entry e2 : msg.subMessageMap().entrySet()) {
            ImmutableJSON.flatJson((ImmutableMessage)e2.getValue(), node, prefix + "_" + (String)e2.getKey());
        }
        return node;
    }

    public static ObjectNode json(ImmutableMessage msg) throws IOException {
        ObjectNode node = objectMapper.createObjectNode();
        msg.toTypedDataMap().entrySet().forEach(e -> ImmutableJSON.resolveValue(objectMapper, node, (String)e.getKey(), ((ImmutableMessage.TypedData)e.getValue()).type, Optional.ofNullable(((ImmutableMessage.TypedData)e.getValue()).value), false));
        for (Map.Entry e2 : msg.subMessageListMap().entrySet()) {
            String key = (String)e2.getKey();
            ArrayNode nd = objectMapper.createArrayNode();
            for (ImmutableMessage submsg : (List)e2.getValue()) {
                nd.add((JsonNode)ImmutableJSON.json(submsg));
            }
            node.set(key, (JsonNode)nd);
        }
        for (Map.Entry e2 : msg.subMessageMap().entrySet()) {
            node.set((String)e2.getKey(), (JsonNode)ImmutableJSON.json((ImmutableMessage)e2.getValue()));
        }
        return node;
    }

    public static String ndJson(ImmutableMessage msg) throws IOException {
        return objectMapper.writeValueAsString((Object)ImmutableJSON.json(msg));
    }

    public static byte[] jsonSerializer(ImmutableMessage msg, boolean includeNullValues, boolean includeTypes) {
        try {
            ObjectWriter w = objectMapper.writerWithDefaultPrettyPrinter();
            return w.writeValueAsBytes((Object)ImmutableJSON.toJSON(msg, includeNullValues, includeTypes));
        }
        catch (JsonProcessingException e) {
            logger.error("JSON parsing failing with value: {} types: {} submessagenames: {}", new Object[]{msg.values(), msg.types(), msg.subMessageMap().keySet()});
            logger.error("Error serializing, got json error:", (Throwable)e);
            if (e.getCause() != null) {
                logger.error("Error serializing:", (Throwable)e);
            }
            try {
                logger.error("JSON failed to write: {}", (Object)ImmutableJSON.toJSON(msg, includeNullValues, includeTypes));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return "{}".getBytes();
        }
    }

    public static ObjectNode toJSON(ImmutableMessage msg, boolean includeNullValues, boolean includeTypes) {
        ObjectNode result = objectMapper.createObjectNode();
        msg.columnNames().forEach(column -> {
            ImmutableMessage.ValueType type = msg.columnType(column);
            result.put(column + ".type", ImmutableTypeParser.typeName((ImmutableMessage.ValueType)type));
            ImmutableJSON.resolveValue(objectMapper, result, column, type, msg.value(column), includeNullValues);
        });
        msg.subMessageListMap().entrySet().forEach(e -> {
            String key = (String)e.getKey();
            ArrayNode nd = objectMapper.createArrayNode();
            ((List)e.getValue()).stream().map(x -> ImmutableJSON.toJSON(x, includeNullValues, includeTypes)).forEach(arg_0 -> ((ArrayNode)nd).add(arg_0));
            result.set(key, (JsonNode)nd);
        });
        msg.subMessageMap().entrySet().forEach(e -> {
            String key = (String)e.getKey();
            result.set(key, (JsonNode)ImmutableJSON.toJSON((ImmutableMessage)e.getValue(), includeNullValues, includeTypes));
        });
        return result;
    }

    private static void resolveValue(ObjectMapper objectMapper, ObjectNode m, String key, ImmutableMessage.ValueType type, Optional<Object> maybeValue, boolean includeNullValues) {
        if (!maybeValue.isPresent()) {
            if (includeNullValues) {
                m.putNull(key);
            }
            return;
        }
        if (type == null) {
            logger.error("Null type for key: {}", (Object)key);
            return;
        }
        Object value = maybeValue.get();
        switch (type) {
            case STRING: 
            case BINARY_DIGEST: {
                m.put(key, (String)value);
                return;
            }
            case INTEGER: {
                m.put(key, (Integer)value);
                return;
            }
            case LONG: {
                m.put(key, (Long)value);
                return;
            }
            case DOUBLE: {
                m.put(key, (Double)value);
                return;
            }
            case FLOAT: {
                m.put(key, (Float)value);
                return;
            }
            case BOOLEAN: {
                m.put(key, (Boolean)value);
                return;
            }
            case DATE: {
                if (value instanceof String) {
                    m.put(key, (String)value);
                } else {
                    String t = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS").format((Date)value);
                    m.put(key, t);
                }
                return;
            }
            case CLOCKTIME: {
                if (value instanceof String) {
                    m.put(key, (String)value);
                } else {
                    String c = new SimpleDateFormat("HH:mm:ss").format((Date)value);
                    m.put(key, c);
                }
                return;
            }
            case STRINGLIST: {
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    ArrayNode arrayNode = m.putArray(key);
                    ArrayNode valueToTree = (ArrayNode)objectMapper.valueToTree((Object)values);
                    arrayNode.addAll(valueToTree);
                }
                return;
            }
            case LIST: {
                if (value instanceof String[]) {
                    ArrayNode arrayNode = m.putArray(key);
                    ArrayNode valueToTree = (ArrayNode)objectMapper.valueToTree(value);
                    arrayNode.addAll(valueToTree);
                    break;
                }
                logger.warn("Bad type mapping, key: {} of type: list has actual class: {}. Treating as string for now.", (Object)key, value.getClass());
                String stringify = value.toString();
                m.put(key, stringify);
                break;
            }
        }
    }

    private static Object resolveValue(ImmutableMessage.ValueType type, JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode instanceof NullNode) {
            return null;
        }
        switch (type) {
            case STRING: 
            case BINARY_DIGEST: {
                return jsonNode.asText();
            }
            case INTEGER: {
                return jsonNode.asInt();
            }
            case LONG: {
                return jsonNode.asLong();
            }
            case DOUBLE: 
            case FLOAT: {
                return jsonNode.asDouble();
            }
            case BOOLEAN: {
                return jsonNode.asBoolean();
            }
            case STRINGLIST: {
                ArrayNode nodes = (ArrayNode)jsonNode;
                ArrayList<String> resultStringList = new ArrayList<String>();
                for (JsonNode objNode : nodes) {
                    if (objNode.isTextual()) {
                        resultStringList.add(objNode.asText());
                        continue;
                    }
                    logger.warn("Unsupported array element type: {} in {}. Ignoring!", (Object)objNode, (Object)jsonNode);
                }
                String[] converted = resultStringList.toArray(new String[0]);
                return converted;
            }
            case LIST: {
                ArrayNode node = (ArrayNode)jsonNode;
                ArrayList<Object> result = new ArrayList<Object>();
                for (JsonNode objNode : node) {
                    if (objNode.isInt()) {
                        result.add(objNode.asInt());
                        continue;
                    }
                    if (objNode.isTextual()) {
                        result.add(objNode.asText());
                        continue;
                    }
                    logger.warn("Unsupported array element type: {} in {}. Ignoring!", (Object)objNode, (Object)jsonNode);
                }
                return result;
            }
            case DATE: {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS").parse(jsonNode.asText());
                }
                catch (ParseException e) {
                    logger.warn("Cannot parse date {} = returning null", (Object)jsonNode.asText());
                    return null;
                }
            }
            case CLOCKTIME: {
                try {
                    return new SimpleDateFormat("HH:mm:ss").parse(jsonNode.asText());
                }
                catch (ParseException e) {
                    logger.warn("Cannot parse clocktime {} = returning null", (Object)jsonNode.asText());
                    return null;
                }
            }
        }
        logger.warn("Unsupported type {}", (Object)type);
        return null;
    }

    public static ImmutableMessage parseJSON(ObjectNode node) {
        HashMap<String, JsonNode> localvalues = new HashMap<String, JsonNode>();
        HashMap<String, ImmutableMessage.ValueType> localtypes = new HashMap<String, ImmutableMessage.ValueType>();
        HashMap<String, Object> subMessageMap = new HashMap<String, Object>();
        HashMap<String, Object> subMessageListMap = new HashMap<String, Object>();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Object submsg;
            Map.Entry e2 = (Map.Entry)fields.next();
            JsonNode value = (JsonNode)e2.getValue();
            if (value.isObject()) {
                ObjectNode on = (ObjectNode)value;
                submsg = ImmutableJSON.parseJSON(on);
                subMessageMap.put((String)e2.getKey(), submsg);
                continue;
            }
            if (value.isArray()) {
                ArrayNode an = (ArrayNode)value;
                submsg = new ArrayList();
                for (JsonNode jsonNode : an) {
                    ImmutableMessage sm = ImmutableJSON.parseJSON((ObjectNode)jsonNode);
                    submsg.add(sm);
                }
                subMessageListMap.put((String)e2.getKey(), submsg);
                continue;
            }
            String name = (String)e2.getKey();
            if (name.endsWith(".type")) {
                String columnName = name.substring(0, name.length() - ".type".length());
                localtypes.put(columnName, ImmutableTypeParser.parseType((String)((JsonNode)e2.getValue()).asText()));
                continue;
            }
            localvalues.put((String)e2.getKey(), (JsonNode)e2.getValue());
        }
        HashMap values = new HashMap();
        localvalues.entrySet().stream().forEach(e -> {
            Object value = ImmutableJSON.resolveValue((ImmutableMessage.ValueType)localtypes.get(e.getKey()), (JsonNode)e.getValue());
            values.put((String)e.getKey(), value);
        });
        return ImmutableFactory.create(values, localtypes);
    }
}

