/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.types.ResolvedArrayType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ModelReferenceProvider;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;

public class ResolvedTypes {
    private ResolvedTypes() {
        throw new UnsupportedOperationException();
    }

    public static String simpleQualifiedTypeName(ResolvedType type) {
        if (type instanceof ResolvedPrimitiveType) {
            Class primitiveType = type.getErasedType();
            return Types.typeNameFor(primitiveType);
        }
        if (type instanceof ResolvedArrayType) {
            return Types.typeNameFor(type.getArrayElementType().getErasedType());
        }
        return type.getErasedType().getName();
    }

    public static AllowableValues allowableValues(ResolvedType resolvedType) {
        List typeParameters;
        if (Collections.isContainerType(resolvedType) && (typeParameters = resolvedType.getTypeParameters()) != null && typeParameters.size() == 1) {
            return Enums.allowableValues((Class)((ResolvedType)typeParameters.get(0)).getErasedType());
        }
        return Enums.allowableValues((Class)resolvedType.getErasedType());
    }

    public static Optional<String> resolvedTypeSignature(ResolvedType resolvedType) {
        return Optional.ofNullable(resolvedType).map(ResolvedType::getSignature);
    }

    public static boolean isVoid(ResolvedType returnType) {
        if (returnType == null) {
            return false;
        }
        return Void.class.equals((Object)returnType.getErasedType()) || Void.TYPE.equals(returnType.getErasedType());
    }

    public static Function<ResolvedType, ModelReference> modelRefFactory(ModelContext parentContext, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor, Map<String, String> knownNames) {
        return new ModelReferenceProvider(typeNameExtractor, enumTypeDeterminer, parentContext, knownNames);
    }

    public static Function<ResolvedType, ModelReference> modelRefFactory(ModelContext parentContext, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor) {
        return new ModelReferenceProvider(typeNameExtractor, enumTypeDeterminer, parentContext, new HashMap<String, String>());
    }
}

