/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.io.Serializable;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcores.CommonCore;
import net.jcores.options.Option;
import net.jcores.utils.internal.Folder;
import net.jcores.utils.internal.Mapper;
import net.jcores.utils.internal.system.ProfileInformation;

public abstract class Core
implements Serializable {
    private static final long serialVersionUID = 2195880634253143587L;
    protected transient CommonCore commonCore;

    protected Core(CommonCore core) {
        this.commonCore = core;
    }

    public abstract int size();

    protected void map(final Mapper mapper, Option ... options) {
        final int size = mapper.core().size();
        if (size <= 0) {
            return;
        }
        if (size == 1) {
            mapper.handle(0);
            return;
        }
        ProfileInformation profileInfo = this.commonCore.profileInformation();
        final int STEP_SIZE = Math.max(this.size() / 10, 1);
        int NUM_THREADS = Runtime.getRuntime().availableProcessors();
        final AtomicInteger index = new AtomicInteger();
        long delta = 0L;
        int i = 0;
        while (i < size) {
            if (mapper.core().t[i] != null) {
                index.set(i + 1);
                long start = System.nanoTime();
                mapper.handle(i);
                delta = System.nanoTime() - start;
                break;
            }
            ++i;
        }
        int toGo = size - index.get();
        long estTime = delta * (long)toGo;
        if (estTime < 2L * profileInfo.forkTime && toGo > 1) {
            int i2 = index.get();
            while (i2 < size) {
                mapper.handle(i2);
                ++i2;
            }
            return;
        }
        final CyclicBarrier barrier = new CyclicBarrier(NUM_THREADS + 1);
        final AtomicInteger baseCount = new AtomicInteger();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                int bc = baseCount.getAndIncrement() * STEP_SIZE;
                int lower = Math.max(index.get(), bc);
                while (lower < size) {
                    int max = Math.min(Math.min(lower + STEP_SIZE, size), bc + STEP_SIZE);
                    int i = lower;
                    while (i < max) {
                        mapper.handle(i);
                        ++i;
                    }
                    lower = bc = baseCount.getAndIncrement() * STEP_SIZE;
                }
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (BrokenBarrierException e) {
                    e.printStackTrace();
                }
            }
        };
        this.commonCore.execute(runner, NUM_THREADS);
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    protected void fold(final Folder folder, Option ... options) {
        final int size = folder.core().size();
        if (size <= 1) {
            return;
        }
        if (size == 2) {
            folder.handle(0, 1, 0);
            return;
        }
        int NUM_THREADS = Runtime.getRuntime().availableProcessors();
        final AtomicInteger baseCount = new AtomicInteger();
        final AtomicInteger level = new AtomicInteger();
        final CyclicBarrier levelbarrier = new CyclicBarrier(NUM_THREADS);
        final CyclicBarrier barrier = new CyclicBarrier(NUM_THREADS + 1);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                int lvl = level.get();
                int dist = (int)Math.pow(2.0, lvl);
                while (dist < size) {
                    int upperBound = size - dist;
                    int i = baseCount.getAndAdd(2) * dist;
                    int j = i + dist;
                    while (j <= upperBound) {
                        folder.handle(i, j, i);
                        i = baseCount.getAndAdd(2) * dist;
                        j = i + dist;
                    }
                    if (i <= upperBound && i > 0) {
                        int left = i - (int)Math.pow(2.0, lvl + 1);
                        folder.handle(left, i, left);
                    }
                    try {
                        levelbarrier.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (BrokenBarrierException e) {
                        e.printStackTrace();
                    }
                    if (level.compareAndSet(lvl, lvl + 1)) {
                        baseCount.set(0);
                    }
                    lvl = level.get();
                    dist = (int)Math.pow(2.0, lvl);
                }
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (BrokenBarrierException e) {
                    e.printStackTrace();
                }
            }
        };
        this.commonCore.execute(runner, NUM_THREADS);
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }
}

