/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.utils.internal.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.options.MessageType;
import net.jcores.options.Option;

public class FileUtils {
    public static String readText(CommonCore cc, File file) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            cc.report(MessageType.EXCEPTION, "File not found " + file);
        }
        catch (IOException e) {
            cc.report(MessageType.EXCEPTION, "Error reading from file " + file);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    cc.report(MessageType.EXCEPTION, "Error closing file " + file);
                }
            }
        }
        return null;
    }

    public static File[] dir(File root, boolean listDirs) {
        ArrayList<File> rval = new ArrayList<File>();
        ArrayList<File> next = new ArrayList<File>();
        File[] listed = root.listFiles();
        if (listed == null) {
            return null;
        }
        next.addAll(Arrays.asList(listed));
        while (next.size() > 0) {
            listed = next.toArray(new File[0]);
            next.clear();
            File[] fileArray = listed;
            int n = listed.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    rval.add(file);
                } else {
                    File[] listFiles;
                    if (listDirs) {
                        rval.add(file);
                    }
                    if ((listFiles = file.listFiles()) != null) {
                        next.addAll(Arrays.asList(listFiles));
                    }
                }
                ++n2;
            }
        }
        return rval.toArray(new File[0]);
    }

    public static File[] copy(CommonCore cc, File from, File to) {
        File realTo;
        block28: {
            boolean fromdir;
            boolean todir = to.getAbsolutePath().endsWith("/") || to.isDirectory();
            boolean bl = fromdir = from.getAbsolutePath().endsWith("/") || from.isDirectory();
            if (fromdir) {
                File[] elements = FileUtils.dir(from, false);
                ArrayList<File> files = new ArrayList<File>();
                File[] fileArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String subname = file.getAbsolutePath().replace(from.getAbsolutePath(), "");
                    files.addAll(Arrays.asList(FileUtils.copy(cc, file, new File(to + "/" + subname))));
                    ++n2;
                }
                return files.toArray(new File[0]);
            }
            if (todir) {
                to.mkdirs();
            } else {
                to.getParentFile().mkdirs();
            }
            realTo = todir ? new File(to.getAbsoluteFile() + "/" + from.getName()) : to;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                try {
                    fis = new FileInputStream(from);
                    fos = new FileOutputStream(realTo);
                    byte[] buf = new byte[65536];
                    int i = 0;
                    while ((i = fis.read(buf)) != -1) {
                        fos.write(buf, 0, i);
                    }
                }
                catch (Exception e) {
                    cc.report(MessageType.EXCEPTION, "Error copying file " + from + " " + to + " due to a " + e.getMessage());
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return new File[]{realTo};
    }

    public static void zipFiles(File target, File[] t) {
        byte[] buffer = new byte[32768];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(target));
            File[] fileArray = t;
            int n = t.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File[] toStore = file.isDirectory() ? CoreKeeper.$(file).dir(new Option[0]).array(File.class) : CoreKeeper.$(file).array(File.class);
                String absolute = file.getAbsolutePath();
                File[] fileArray2 = toStore;
                int n3 = toStore.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file2 = fileArray2[n4];
                    String entryname = file.isDirectory() ? file2.getAbsolutePath().substring(absolute.length() + 1) : file2.getName();
                    try {
                        int bytesRead;
                        FileInputStream in = new FileInputStream(file2);
                        ZipEntry entry = new ZipEntry(entryname);
                        out.putNextEntry(entry);
                        while ((bytesRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                        in.close();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
                ++n2;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

