/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.utils.internal.sound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundUtils {
    private static final int EXTERNAL_BUFFER_SIZE = 524288;

    public static void playSound(AudioInputStream audioInputStream) {
        AudioFormat format = audioInputStream.getFormat();
        SourceDataLine auline = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            auline = (SourceDataLine)AudioSystem.getLine(info);
            auline.open(format);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        auline.start();
        int nBytesRead = 0;
        byte[] abData = new byte[524288];
        try {
            try {
                while (nBytesRead != -1) {
                    nBytesRead = audioInputStream.read(abData, 0, abData.length);
                    if (nBytesRead < 0) continue;
                    auline.write(abData, 0, nBytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                auline.drain();
                auline.close();
                return;
            }
        }
        finally {
            auline.drain();
            auline.close();
        }
    }

    public static AudioInputStream getStream(File file) {
        try {
            return SoundUtils.getStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static AudioInputStream getStream(InputStream file) {
        try {
            return AudioSystem.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

