/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginInformation;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.annotations.Capabilities;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.injections.InjectPlugin;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.annotations.meta.Stateless;
import net.xeoh.plugins.base.annotations.meta.Version;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.registry.PluginMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginRegistry;

@Author(name="Ralf Biedert")
@Version(version=10000)
@Stateless
@PluginImplementation
public class PluginInformationImpl
implements PluginInformation {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    @InjectPlugin
    public PluginManager pluginManager;

    private PluginInformationImpl() {
    }

    @Override
    public Collection<String> getInformation(PluginInformation.Information item, Plugin plugin) {
        PluginManagerImpl pmi = (PluginManagerImpl)this.pluginManager;
        ArrayList<String> rval = new ArrayList<String>();
        switch (item) {
            case CAPABILITIES: {
                String[] caps;
                for (String string : caps = this.getCaps(plugin)) {
                    rval.add(string);
                }
                break;
            }
            case AUTHORS: {
                Author author = plugin.getClass().getAnnotation(Author.class);
                if (author == null) break;
                rval.add(author.name());
                break;
            }
            case VERSION: {
                Version version = plugin.getClass().getAnnotation(Version.class);
                if (version == null) break;
                rval.add(Integer.toString(version.version()));
                break;
            }
            case CLASSPATH_ORIGIN: {
                PluginRegistry pluginRegistry = pmi.getPluginRegistry();
                PluginMetaInformation metaInformation = pluginRegistry.getMetaInformationFor(plugin);
                if (metaInformation == null || metaInformation.classMeta == null || metaInformation.classMeta.pluginOrigin == null) break;
                rval.add(metaInformation.classMeta.pluginOrigin.toString());
                break;
            }
            default: {
                this.logger.info("Requested InformationItem is not known!");
            }
        }
        return rval;
    }

    private String[] getCaps(Plugin plugin) {
        Method[] methods;
        Class<?> spawnClass = plugin.getClass();
        for (Method method : methods = spawnClass.getMethods()) {
            Capabilities caps = method.getAnnotation(Capabilities.class);
            if (caps == null) continue;
            Object result = null;
            try {
                result = method.invoke((Object)plugin, new Object[0]);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (result == null || !(result instanceof String[])) continue;
            return (String[])result;
        }
        return new String[0];
    }
}

