/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import net.jcores.CoreKeeper;
import net.jcores.interfaces.functions.F1;
import net.jcores.options.Option;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.diagnosis.channels.tracing.SpawnerTracer;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.options.GetPluginOption;
import net.xeoh.plugins.base.util.PluginConfigurationUtil;
import net.xeoh.plugins.diagnosis.local.Diagnosis;
import net.xeoh.plugins.diagnosis.local.options.ChannelOption;
import net.xeoh.plugins.diagnosis.local.options.StatusOption;
import net.xeoh.plugins.diagnosis.local.util.DiagnosisChannelUtil;

public class ClassPathLocator {
    private final JARCache cache;
    private PluginManagerImpl pluginManager;

    public ClassPathLocator(PluginManagerImpl pluginManager, JARCache cache) {
        this.pluginManager = pluginManager;
        this.cache = cache;
    }

    public Collection<AbstractClassPathLocation> findBelow(URI toplevel) {
        ArrayList<AbstractClassPathLocation> rval = new ArrayList<AbstractClassPathLocation>();
        File startPoint = new File(toplevel);
        if (CoreKeeper.$(startPoint).filter(".*\\.plugin?$", new Option[0]).get(false) != null) {
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
            return rval;
        }
        if (startPoint.isDirectory()) {
            File[] listFiles = startPoint.listFiles();
            boolean hasJARs = false;
            for (File file : listFiles) {
                if (file.getAbsolutePath().endsWith(".jar")) {
                    rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, file.toURI().toString(), file.toURI()));
                    hasJARs = true;
                }
                if (CoreKeeper.$(file).filter(".*\\.plugin?$", new Option[0]).get(false) == null) continue;
                rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, file.toURI().toString(), file.toURI()));
                hasJARs = true;
            }
            if (hasJARs) {
                return rval;
            }
            if (toplevel.toString().contains("/bin/") || toplevel.toString().contains("class")) {
                System.err.println("Adding plugins in 'raw' classpaths, such as 'bin/' or 'classes/' is not recommended. Please use classpath://* instead (the video is a bit outdated in this respect).");
            }
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
            return rval;
        }
        if (startPoint.isFile() && startPoint.getAbsolutePath().endsWith(".jar")) {
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
            return rval;
        }
        return rval;
    }

    public Collection<AbstractClassPathLocation> findInCurrentClassPath() {
        final DiagnosisChannelUtil<String> channel = new DiagnosisChannelUtil<String>(this.pluginManager.getPlugin(Diagnosis.class, new GetPluginOption[0]).channel(SpawnerTracer.class, new ChannelOption[0]));
        channel.status("findinclasspath/start", new StatusOption[0]);
        ArrayList<AbstractClassPathLocation> rval = new ArrayList<AbstractClassPathLocation>();
        boolean filter = new PluginConfigurationUtil(this.pluginManager.getPluginConfiguration()).getBoolean(PluginManager.class, "classpath.filter.default.enabled", true);
        String[] blacklist = new PluginConfigurationUtil(this.pluginManager.getPluginConfiguration()).getString(PluginManager.class, "classpath.filter.default.pattern", "/jre/lib/;/jdk/lib/;/lib/rt.jar").split(";");
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        ArrayList<URL> toFilter = new ArrayList<URL>();
        String[] classpaths = classpath.split(pathSep);
        channel.status("findinclasspath/status", new Serializable[]{"pathseparator", pathSep, "blacklist", CoreKeeper.$(blacklist).join(";")});
        URLClassLoader ourloader = CoreKeeper.$(this.getClass().getClassLoader()).cast(URLClassLoader.class).get((URLClassLoader)false);
        while (ourloader != ClassLoader.getSystemClassLoader() && ourloader != null) {
            channel.status("findinclasspath/urlloader", new StatusOption[0]);
            classpaths = CoreKeeper.$(ourloader.getURLs()).file().forEach(new F1<File, String>(){

                @Override
                public String f(File arg0) {
                    channel.status("findinclasspath/urlloader/path", new Serializable[]{"path", arg0});
                    return arg0.getAbsolutePath();
                }
            }, new Option[0]).add((String[])classpaths).unique().array(String.class);
            ourloader = CoreKeeper.$(ourloader.getParent()).cast(URLClassLoader.class).get((URLClassLoader)false);
        }
        if (filter) {
            ClassLoader loader;
            channel.status("findinclasspath/filter", new StatusOption[0]);
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
            if (loader != null && loader instanceof URLClassLoader) {
                URL[] urls;
                for (URL url : urls = ((URLClassLoader)loader).getURLs()) {
                    channel.status("findinclasspath/filter/add", new Serializable[]{"item", url});
                    toFilter.add(url);
                }
            }
        }
        for (String string : classpaths) {
            try {
                URL url = new File(string).toURI().toURL();
                channel.status("findinclasspath/add", new Serializable[]{"raw", string, "url", url});
                if (toFilter.contains(url) || this.blacklisted(blacklist, url)) {
                    channel.status("findinclasspath/add/blacklisted", new Serializable[]{"raw", string, "url", url});
                    continue;
                }
                rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, "#classpath", new File(string).toURI()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return rval;
    }

    private boolean blacklisted(String[] blacklist, URL url) {
        if (blacklist == null || blacklist.length == 0 || blacklist[0].length() == 0) {
            return false;
        }
        for (String string : blacklist) {
            if (!url.toString().contains(string)) continue;
            return true;
        }
        return false;
    }
}

