/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.spawning.handler;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.annotations.injections.InjectPlugin;
import net.xeoh.plugins.base.impl.registry.PluginClassMetaInformation;
import net.xeoh.plugins.base.impl.spawning.handler.AbstractHandler;
import net.xeoh.plugins.base.options.getplugin.OptionCapabilities;

public class InjectHandler
extends AbstractHandler {
    public InjectHandler(PluginManager pluginManager) {
        super(pluginManager);
    }

    @Override
    public void init(Plugin plugin) throws Exception {
        String[] capabilities;
        InjectPlugin ipannotation;
        Field[] fields = plugin.getClass().getFields();
        Method[] methods = plugin.getClass().getMethods();
        for (Field field : fields) {
            field.setAccessible(true);
            ipannotation = field.getAnnotation(InjectPlugin.class);
            if (ipannotation == null) continue;
            capabilities = ipannotation.requiredCapabilities();
            Class<?> typeOfField = field.getType();
            this.logger.fine("Injecting plugin by autodetection (" + typeOfField.getName() + ") into " + plugin.getClass().getName());
            field.set(plugin, this.getEntityForType(typeOfField, capabilities));
        }
        for (AccessibleObject accessibleObject : methods) {
            ((Method)accessibleObject).setAccessible(true);
            ipannotation = ((Method)accessibleObject).getAnnotation(InjectPlugin.class);
            if (ipannotation == null) continue;
            capabilities = ipannotation.requiredCapabilities();
            Class<?> typeOfMethod = ((Method)accessibleObject).getParameterTypes()[0];
            this.logger.fine("Injecting plugin by autodetection (" + typeOfMethod.getName() + ") into " + plugin.getClass().getName());
            try {
                ((Method)accessibleObject).invoke(plugin, this.getEntityForType(typeOfMethod, capabilities));
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Unable to inject plugin " + typeOfMethod + " into method " + accessibleObject);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.warning("Unable to inject plugin " + typeOfMethod + " into method " + accessibleObject);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deinit(Plugin plugin) throws Exception {
    }

    Class<?> getTrueDependencyInterfaceType(Class<?> type) {
        if (type.isInterface()) {
            return type;
        }
        try {
            Constructor<?>[] declaredConstructors;
            for (Constructor<?> constructor : declaredConstructors = type.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(type)) continue;
                return parameterTypes[0];
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    Plugin getEntityForType(Class<?> type, String ... capabilities) {
        Object plugin = this.pluginManager.getPlugin(this.getTrueDependencyInterfaceType(type), new OptionCapabilities(capabilities));
        if (type.isInterface()) {
            return plugin;
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = type.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(type)) continue;
                return (Plugin)constructor.newInstance(plugin);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Collection<PluginClassMetaInformation.Dependency> getDependencies(Class<? extends Plugin> pluginClass) {
        PluginClassMetaInformation.Dependency d;
        InjectPlugin ipannotation;
        ArrayList<PluginClassMetaInformation.Dependency> rval = new ArrayList<PluginClassMetaInformation.Dependency>();
        Field[] fields = pluginClass.getFields();
        Method[] methods = pluginClass.getMethods();
        for (Field field : fields) {
            field.setAccessible(true);
            ipannotation = field.getAnnotation(InjectPlugin.class);
            if (ipannotation == null || ipannotation.isOptional()) continue;
            d = new PluginClassMetaInformation.Dependency();
            d.capabilites = ipannotation.requiredCapabilities();
            d.pluginClass = this.getTrueDependencyInterfaceType(field.getType());
            d.isOptional = ipannotation.isOptional();
            rval.add(d);
        }
        for (AccessibleObject accessibleObject : methods) {
            ((Method)accessibleObject).setAccessible(true);
            ipannotation = ((Method)accessibleObject).getAnnotation(InjectPlugin.class);
            if (ipannotation == null || ipannotation.isOptional()) continue;
            d = new PluginClassMetaInformation.Dependency();
            d.capabilites = ipannotation.requiredCapabilities();
            d.pluginClass = this.getTrueDependencyInterfaceType(((Method)accessibleObject).getParameterTypes()[0]);
            d.isOptional = ipannotation.isOptional();
            rval.add(d);
        }
        return rval;
    }
}

