/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.client;

import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;

public class RepositoryFactoryImpl
implements RepositoryFactory {
    public static final String PARAM_REPOSITORY_SERVICE_FACTORY = "org.apache.jackrabbit.spi.RepositoryServiceFactory";
    public static final String PARAM_REPOSITORY_CONFIG = "org.apache.jackrabbit.jcr2spi.RepositoryConfig";

    public Repository getRepository(Map parameters) throws RepositoryException {
        Object repositoryFactory;
        String repositoryFactoryName = parameters != null && (parameters.containsKey(PARAM_REPOSITORY_SERVICE_FACTORY) || parameters.containsKey(PARAM_REPOSITORY_CONFIG)) ? "org.apache.jackrabbit.jcr2spi.Jcr2spiRepositoryFactory" : "org.apache.jackrabbit.core.RepositoryFactoryImpl";
        try {
            Class<?> repositoryFactoryClass = Class.forName(repositoryFactoryName, true, Thread.currentThread().getContextClassLoader());
            repositoryFactory = repositoryFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        if (repositoryFactory instanceof RepositoryFactory) {
            return ((RepositoryFactory)repositoryFactory).getRepository(parameters);
        }
        throw new RepositoryException(repositoryFactory + " is not a RepositoryFactory");
    }
}

