/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.lang.reflect.Constructor;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExceptionConverter {
    private ExceptionConverter() {
    }

    public static RepositoryException generate(DavException davExc) {
        return ExceptionConverter.generate(davExc, null);
    }

    public static RepositoryException generate(DavException davExc, HttpRequestBase request) {
        String name = request == null ? "_undefined_" : request.getMethod();
        int code = DavMethods.getMethodCode((String)name);
        return ExceptionConverter.generate(davExc, code, name);
    }

    public static RepositoryException generate(DavException davExc, int methodCode, String name) {
        String msg = davExc.getMessage();
        if (davExc.hasErrorCondition()) {
            try {
                Element error = davExc.toXml(DomUtil.createDocument());
                if (DomUtil.matches((Node)error, (String)"error", (Namespace)DavConstants.NAMESPACE) && DomUtil.hasChildElement((Node)error, (String)"exception", null)) {
                    Class<?> cl;
                    Constructor<?> excConstr;
                    Element exc = DomUtil.getChildElement((Node)error, (String)"exception", null);
                    if (DomUtil.hasChildElement((Node)exc, (String)"message", null)) {
                        msg = DomUtil.getChildText((Element)exc, (String)"message", null);
                    }
                    if (DomUtil.hasChildElement((Node)exc, (String)"class", null) && (excConstr = (cl = Class.forName(DomUtil.getChildText((Element)exc, (String)"class", null))).getConstructor(String.class)) != null) {
                        Object o = excConstr.newInstance(msg);
                        if (o instanceof PathNotFoundException && methodCode == 4) {
                            return new InvalidItemStateException(msg);
                        }
                        if (o instanceof RepositoryException) {
                            return (RepositoryException)((Object)o);
                        }
                        if (o instanceof Exception) {
                            return new RepositoryException(msg, (Throwable)((Exception)o));
                        }
                    }
                }
            }
            catch (Exception e) {
                return new RepositoryException((Throwable)e);
            }
        }
        switch (davExc.getErrorCode()) {
            case 404: {
                switch (methodCode) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: {
                        return new InvalidItemStateException(msg, (Throwable)davExc);
                    }
                }
                return new ItemNotFoundException(msg, (Throwable)davExc);
            }
            case 423: {
                return new LockException(msg, (Throwable)davExc);
            }
            case 405: {
                return new ConstraintViolationException(msg, (Throwable)davExc);
            }
            case 409: {
                return new InvalidItemStateException(msg, (Throwable)davExc);
            }
            case 412: {
                return new LockException(msg, (Throwable)davExc);
            }
            case 501: {
                if (methodCode > 0 && name != null) {
                    return new UnsupportedRepositoryOperationException("Missing implementation: Method " + name + " could not be executed", (Throwable)davExc);
                }
                return new UnsupportedRepositoryOperationException("Missing implementation", (Throwable)davExc);
            }
        }
        return new RepositoryException(msg, (Throwable)davExc);
    }
}

