/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import com.google.common.annotations.Beta;
import java.util.function.Function;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.filtering.DeferredColumn;
import tech.tablesaw.filtering.NumberFilterSpec;
import tech.tablesaw.selection.Selection;

@Beta
public class DeferredNumberColumn
extends DeferredColumn
implements NumberFilterSpec<Function<Table, Selection>> {
    public DeferredNumberColumn(String columnName) {
        super(columnName);
    }

    @Override
    public Function<Table, Selection> isEqualTo(double other) {
        return table -> table.numberColumn(this.name()).isEqualTo(other);
    }

    @Override
    public Function<Table, Selection> isBetweenExclusive(double start, double end) {
        return table -> table.numberColumn(this.name()).isBetweenExclusive(start, end);
    }

    @Override
    public Function<Table, Selection> isBetweenInclusive(double start, double end) {
        return table -> table.numberColumn(this.name()).isBetweenInclusive(start, end);
    }

    @Override
    public Function<Table, Selection> isGreaterThan(double f) {
        return table -> table.numberColumn(this.name()).isGreaterThan(f);
    }

    @Override
    public Function<Table, Selection> isGreaterThanOrEqualTo(double f) {
        return table -> table.numberColumn(this.name()).isGreaterThanOrEqualTo(f);
    }

    @Override
    public Function<Table, Selection> isLessThan(double f) {
        return table -> table.numberColumn(this.name()).isLessThan(f);
    }

    @Override
    public Function<Table, Selection> isLessThanOrEqualTo(double f) {
        return table -> table.numberColumn(this.name()).isLessThanOrEqualTo(f);
    }

    @Override
    public Function<Table, Selection> isIn(Number ... numbers) {
        return table -> table.numberColumn(this.name()).isIn(numbers);
    }

    @Override
    public Function<Table, Selection> isIn(double ... doubles) {
        return table -> table.numberColumn(this.name()).isIn(doubles);
    }

    @Override
    public Function<Table, Selection> isNotIn(Number ... numbers) {
        return table -> table.numberColumn(this.name()).isNotIn(numbers);
    }

    @Override
    public Function<Table, Selection> isNotIn(double ... doubles) {
        return table -> table.numberColumn(this.name()).isNotIn(doubles);
    }

    @Override
    public Function<Table, Selection> isZero() {
        return table -> table.numberColumn(this.name()).isZero();
    }

    @Override
    public Function<Table, Selection> isPositive() {
        return table -> table.numberColumn(this.name()).isPositive();
    }

    @Override
    public Function<Table, Selection> isNegative() {
        return table -> table.numberColumn(this.name()).isNegative();
    }

    @Override
    public Function<Table, Selection> isNonNegative() {
        return table -> table.numberColumn(this.name()).isNonNegative();
    }

    @Override
    public Function<Table, Selection> isCloseTo(Number target, Number margin) {
        return table -> table.numberColumn(this.name()).isCloseTo(target, margin);
    }

    @Override
    public Function<Table, Selection> isGreaterThan(NumericColumn<?> d) {
        return table -> table.numberColumn(this.name()).isGreaterThan((NumericColumn)d);
    }

    @Override
    public Function<Table, Selection> isGreaterThanOrEqualTo(NumericColumn<?> d) {
        return table -> table.numberColumn(this.name()).isGreaterThanOrEqualTo((NumericColumn)d);
    }

    @Override
    public Function<Table, Selection> isEqualTo(NumericColumn<?> d) {
        return table -> table.numberColumn(this.name()).isEqualTo((NumericColumn)d);
    }

    @Override
    public Function<Table, Selection> isNotEqualTo(NumericColumn<?> d) {
        return table -> table.numberColumn(this.name()).isNotEqualTo((NumericColumn)d);
    }

    @Override
    public Function<Table, Selection> isLessThan(NumericColumn<?> d) {
        return table -> table.numberColumn(this.name()).isLessThan((NumericColumn)d);
    }

    @Override
    public Function<Table, Selection> isLessThanOrEqualTo(NumericColumn<?> d) {
        return table -> table.numberColumn(this.name()).isLessThanOrEqualTo((NumericColumn)d);
    }
}

