/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.media.OptionFlag;

final class MediaOptions {
    private MediaOptions() {
    }

    static boolean addMediaOptions(libvlc_media_t media, String ... mediaOptions) {
        if (media != null) {
            if (mediaOptions != null) {
                for (String mediaOption : mediaOptions) {
                    LibVlc.libvlc_media_add_option((libvlc_media_t)media, (String)mediaOption);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean addMediaOptions(libvlc_media_t media, String[] mediaOptions, OptionFlag ... flags) {
        if (media != null) {
            int flagsValue = MediaOptions.flagsToInt(flags);
            for (String mediaOption : mediaOptions) {
                LibVlc.libvlc_media_add_option_flag((libvlc_media_t)media, (String)mediaOption, (int)flagsValue);
            }
            return true;
        }
        return false;
    }

    public static boolean addMediaOption(libvlc_media_t media, String mediaOption, OptionFlag ... flags) {
        if (media != null) {
            LibVlc.libvlc_media_add_option_flag((libvlc_media_t)media, (String)mediaOption, (int)MediaOptions.flagsToInt(flags));
            return true;
        }
        return false;
    }

    private static int flagsToInt(OptionFlag ... flags) {
        int result = 0;
        if (flags != null) {
            for (OptionFlag flag : flags) {
                result |= flag.intValue();
            }
        }
        return result;
    }
}

