/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.io.File;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeUri;
import uk.co.caprica.vlcj.media.MediaSlaveType;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.Descriptions;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.TrackDescription;

public final class SubpictureApi
extends BaseApi {
    SubpictureApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public int trackCount() {
        return LibVlc.libvlc_video_get_spu_count((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public int track() {
        return LibVlc.libvlc_video_get_spu((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public int setTrack(int spu) {
        LibVlc.libvlc_video_set_spu((libvlc_media_player_t)this.mediaPlayerInstance, (int)spu);
        return this.track();
    }

    public long delay() {
        return LibVlc.libvlc_video_get_spu_delay((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void setDelay(long delay) {
        LibVlc.libvlc_video_set_spu_delay((libvlc_media_player_t)this.mediaPlayerInstance, (long)delay);
    }

    public boolean setSubTitleFile(String subTitleFileName) {
        return this.setSubTitleUri(NativeUri.encodeFileUri((String)subTitleFileName));
    }

    public boolean setSubTitleFile(File subTitleFile) {
        return this.setSubTitleUri(NativeUri.encodeFileUri((String)subTitleFile.getAbsolutePath()));
    }

    public boolean setSubTitleUri(String uri) {
        return this.mediaPlayer.media().addSlave(MediaSlaveType.SUBTITLE, uri, true);
    }

    public List<TrackDescription> trackDescriptions() {
        return Descriptions.spuTrackDescriptions(this.mediaPlayerInstance);
    }
}

