/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_cleanup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_format_cb;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.NativeBuffers;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

public class CallbackVideoSurface
extends VideoSurface {
    private final libvlc_video_format_cb setup = new SetupCallback();
    private final libvlc_video_cleanup_cb cleanup = new CleanupCallback();
    private final libvlc_lock_callback_t lock = new LockCallback();
    private final libvlc_unlock_callback_t unlock = new UnlockCallback();
    private final libvlc_display_callback_t display = new DisplayCallback();
    private final BufferFormatCallback bufferFormatCallback;
    private final RenderCallback renderCallback;
    private final NativeBuffers nativeBuffers;
    private MediaPlayer mediaPlayer;
    private BufferFormat bufferFormat;

    public CallbackVideoSurface(BufferFormatCallback bufferFormatCallback, RenderCallback renderCallback, boolean lockBuffers, VideoSurfaceAdapter videoSurfaceAdapter) {
        super(videoSurfaceAdapter);
        this.bufferFormatCallback = bufferFormatCallback;
        this.renderCallback = renderCallback;
        this.nativeBuffers = new NativeBuffers(lockBuffers);
    }

    @Override
    public void attach(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
        LibVlc.libvlc_video_set_format_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (libvlc_video_format_cb)this.setup, (libvlc_video_cleanup_cb)this.cleanup);
        LibVlc.libvlc_video_set_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (libvlc_lock_callback_t)this.lock, (libvlc_unlock_callback_t)this.unlock, (libvlc_display_callback_t)this.display, null);
    }

    private final class SetupCallback
    implements libvlc_video_format_cb {
        private SetupCallback() {
        }

        public int format(PointerByReference opaque, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
            CallbackVideoSurface.this.bufferFormat = CallbackVideoSurface.this.bufferFormatCallback.getBufferFormat(width.getValue(), height.getValue());
            this.applyBufferFormat(CallbackVideoSurface.this.bufferFormat, chroma, width, height, pitches, lines);
            int result = CallbackVideoSurface.this.nativeBuffers.allocate(CallbackVideoSurface.this.bufferFormat);
            CallbackVideoSurface.this.bufferFormatCallback.allocatedBuffers(CallbackVideoSurface.this.nativeBuffers.buffers());
            return result;
        }

        private void applyBufferFormat(BufferFormat bufferFormat, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
            byte[] chromaBytes = bufferFormat.getChroma().getBytes();
            chroma.getPointer().write(0L, chromaBytes, 0, chromaBytes.length < 4 ? chromaBytes.length : 4);
            width.setValue(bufferFormat.getWidth());
            height.setValue(bufferFormat.getHeight());
            int[] pitchValues = bufferFormat.getPitches();
            int[] lineValues = bufferFormat.getLines();
            pitches.getPointer().write(0L, pitchValues, 0, pitchValues.length);
            lines.getPointer().write(0L, lineValues, 0, lineValues.length);
        }
    }

    private final class CleanupCallback
    implements libvlc_video_cleanup_cb {
        private CleanupCallback() {
        }

        public void cleanup(Pointer opaque) {
            CallbackVideoSurface.this.nativeBuffers.free();
        }
    }

    private final class LockCallback
    implements libvlc_lock_callback_t {
        private LockCallback() {
        }

        public Pointer lock(Pointer opaque, PointerByReference planes) {
            Pointer[] pointers = CallbackVideoSurface.this.nativeBuffers.pointers();
            planes.getPointer().write(0L, pointers, 0, pointers.length);
            return null;
        }
    }

    private final class UnlockCallback
    implements libvlc_unlock_callback_t {
        private UnlockCallback() {
        }

        public void unlock(Pointer opaque, Pointer picture, Pointer plane) {
        }
    }

    private final class DisplayCallback
    implements libvlc_display_callback_t {
        private DisplayCallback() {
        }

        public void display(Pointer opaque, Pointer picture) {
            CallbackVideoSurface.this.renderCallback.display(CallbackVideoSurface.this.mediaPlayer, CallbackVideoSurface.this.nativeBuffers.buffers(), CallbackVideoSurface.this.bufferFormat);
        }
    }
}

